!=========================================================================
! Copyright (C) GemTalk Systems 2005-2020.  All Rights Reserved.
! 
!  segmentorder_61to20.gs - to be filed into Gemstone v6.1 prior to
!	conversion of repository to Gemstone64 v2.0
!
!  fixes ordering of Segments in SystemRepository to agree with 64bit image
!
! $Id$
!
!=========================================================================

! must be logged in as SystemUser

expectvalue %String
run
"check naming in Globals of the segments with reserved oops"
| report namedSegBlk lf |
report := String new .
lf := Character lf .
namedSegBlk := [:aName :objId | | aSeg namedSeg |
  aSeg := Object _objectWithOop: objId .
  namedSeg := Globals at: aName otherwise: nil .
  report addAll: aName .
  namedSeg == aSeg ifTrue:[
    report addAll:' name ok '; add: lf .
  ] ifFalse:[
    report addAll: aName ; addAll:' incorrect in Globals, fixing'; add: lf .
    Globals at: aName put: aSeg
  ].
]. 
namedSegBlk value: #SystemSegment      value: 3253 .
namedSegBlk value: #DataCuratorSegment value: 3261 .
namedSegBlk value: #SecurityDataSegment value: 3685 .
^ report
%
commit

! ensure default segments exist for GcUser and Nameless
expectvalue true
run
(AllUsers userWithId:'GcUser') defaultSegment class == Segment
%
expectvalue true
run
(AllUsers userWithId:'Nameless') defaultSegment class == Segment
%

expectvalue %String
run
| getSegBlk report lf 
  sysSeg dcSeg tzSeg idxSeg scdSeg pubSeg gcSeg namelessSeg 
  reposSegs firstSegs  identicalSegs  idx |
report := String new .
lf := Character lf .
reposSegs := Array withAll:SystemRepository .
report addAll:'starting Segment count ', reposSegs size asString ; add: lf .
getSegBlk := [:aName | |seg |
  seg := Globals at: aName otherwise: nil .
  seg == nil ifTrue:[ 
    report addAll:'created Segment for ', aName; add: lf .
    seg := Segment newInRepository: SystemRepository 
  ]. 
  seg 
].
sysSeg := Globals at: #SystemSegment  .
dcSeg := Globals at:#DataCuratorSegment .
tzSeg := getSegBlk value:#GsTimeZoneSegment .
idxSeg := getSegBlk value:#GsIndexingSegment .
scdSeg := Globals at:#SecurityDataSegment .
pubSeg := getSegBlk value:#PublishedSegment .
gcSeg := (AllUsers userWithId:'GcUser') defaultSegment .
namelessSeg := (AllUsers userWithId:'Nameless') defaultSegment .

"ordering of firstSegs must match 64bit v2.2 image"
firstSegs := { sysSeg . dcSeg . tzSeg . idxSeg . scdSeg . pubSeg . gcSeg . namelessSeg }.
identicalSegs := IdentitySet withAll: firstSegs .
identicalSegs size = 8 ifFalse:[
  ^ identicalSegs size  "error, return actual size "
].
SystemRepository _basicSize: 0 .
1 to: firstSegs size do:[:j | |aSeg |
  aSeg := firstSegs at:j .
  SystemRepository _basicAt:j put: aSeg .
  reposSegs removeIdentical: aSeg ifAbsent:[
    report addAll:'(firstSegs at: ', j asString , ') not in reposSegs'; add: lf .
  ] .
].
idx := firstSegs size + 1 .
1 to: reposSegs size do:[:k | |aSeg |
  aSeg := reposSegs at: k .
  (identicalSegs includesIdentical: aSeg) ifFalse:[
    identicalSegs add: aSeg .
    SystemRepository _basicAt:idx put: aSeg .
    idx := idx + 1 
  ] ifTrue:[
    report addAll:'found a duplicate Segment'; add: lf .
  ].
].
report addAll:'ending Segment count ', SystemRepository size asString; add: lf .
^ report
%

commit
