!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!    SessionTemps, SymbolDictionary, IdentityDictionary, IdentityKeyValueDictionary, 
!    KeyValueDictionary, AbstractDictionary, Collection, Object
!
!=========================================================================

expectvalue %String
run
| oldCls |
oldCls := Globals at:#SessionTemps otherwise: nil .
oldCls == nil ifTrue:[
  ^ SymbolDictionary _newKernelSubclass: #SessionTemps
    instVarNames: #()
    classVars: #()
    classInstVars: #()
    poolDictionaries: #()
    inDictionary: Globals
    options: #( instancesNonPersistent  ) 
    reservedOop: nil
  ]
ifFalse:[
  ^ 'existing class: ' , oldCls definition
  ]
%

removeallmethods SessionTemps
removeallclassmethods SessionTemps

category: 'For Documentation Installation only'
classmethod: SessionTemps
installDocumentation

self comment:
'Instances of SessionTemps may not be committed. The primary use of this class
 is via the class method #current, which returns an instance of SessionTemps
 that is stored in Transient Session State.

Partial list of keys in  SessionTemps current   used in the base GemStone image:
  #AllIrs
  #ClassVariablesAssociationClass
  #GsHostRandomFile
  #GsPackagePolicy_AuthorInitials
  #GsPackagePolicy_SessionMethodDictionary
  #GsRecompileValuesToKeys
  #gciLibrary
  #INDEX_MANAGER_AUTO_COMMIT
  #IcuCollator_AVAILABLE_COLLATORS
  #Module_pinnedClasses
  #OldLitVars
  #PPPredicateObjectParser_cache
  #TranscriptStream_SessionMutex
  #TranscriptStream_SessionStream
  #TransientSessionMethod_Behaviors

Constraints:
	numElements: SmallInteger
	numCollisions: SmallInteger
	collisionLimit: SmallInteger
	tableSize: SmallInteger' .
%

! ------------------- Class methods for SessionTemps
category: 'Session Temporaries'
classmethod: SessionTemps
current
^ (System __sessionStateAt: 1) ifNil:[ 
  System __sessionStateAt: 1 put: SessionTemps new .
  System __sessionStateAt: 1 
].
%
