!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id: stream2.gs 25510 2011-03-21 16:18:43Z jfoster $
!
! Superclass Hierarchy:
!   Stream, Object.
!
!=========================================================================

! fix 47420
expectvalue /String
run
(Stream classVarAt: #Cr otherwise: nil) ifNil:[ | arr |
  arr := { 
    #Lf . Character codePoint: 10 .
    #Tab . Character codePoint: 9 . }.
  1 to: arr size by: 2 do:[:j |
    Stream _addInvariantClassVar: (arr at: j) value: (arr at: j + 1)
  ]. 
  ^ 'added'
].
^ 'no change'
%

set class Stream
category: 'Adding'

method: 
cr
"Adds a newline to the output stream. (NOT a carriage return)"
  self nextPut: Lf
%
method:
lf
  "Adds a newline to the output stream."
  self nextPut: Lf
%
method:
tab
  "Adds a tab to the output stream."
  self nextPut: Tab
%

level 1
expectvalue true
run
  | strm ary exp |
  strm := PrintStream on: String new .
  strm cr; lf ; space ; tab . "note cr same as lf for PrintStream"
  ary := { } .
  strm contents do:[:c | ary add: c  codePoint ] .
  ary = #( 10 10 32 9 ) ifFalse:[ ^ ary ].
  true
%
level 0

category: 'Private'
classmethod: 
_initializeWriteStreamClassVars: aClass
  "method used in filein of various WriteStream classes. 
   Those classes inherit Lf and Tab classVars from Stream.
  "
  (aClass classVarAt: #Cr otherwise: nil) ifNil:[ | arr |
    arr := {
      #Cr . Character codePoint: 13 .
      #CrLf .  (String new add:(Character codePoint: 13);
                   add: (Character codePoint: 10); immediateInvariant
                  ; yourself ) .
      #CrTab .  (String new add:(Character codePoint: 13);
                   add: (Character codePoint: 9); immediateInvariant
                  ; yourself )   } .
    1 to: arr size by: 2 do:[:j |
      aClass _addInvariantClassVar: (arr at: j) value: (arr at: j + 1)
    ].
    ^ 'added'
  ].
  ^ 'no change'
%
