!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   SymbolKeyValueDictionary, IdentityKeyValueDictionary, KeyValueDictionary, 
!   AbstractDictionary, Collection, Object.
!
!=========================================================================

removeallmethods SymbolKeyValueDictionary
removeallclassmethods SymbolKeyValueDictionary

category: 'For Documentation Installation only'
classmethod: SymbolKeyValueDictionary
installDocumentation

self comment:

'A SymbolKeyValueDictionary is an IdentityKeyValueDictionary in which the keys
 are canonical symbols (a Symbol, DoubleByteSymbol, or QuadByteSymbol).  The separate
 implementation is necessary in order to support canonicalization of the symbols
 that are used as keys.

 SymbolKeyValueDictionaries cannot be used in symbol lists.

Constraints:
	numElements: SmallInteger
	numCollisions: SmallInteger
	collisionLimit: SmallInteger
	tableSize: SmallInteger' .
%

! clusterDepthFirst inherited.

category: 'Updating'
method: SymbolKeyValueDictionary
at: aKey put: aValue

"Stores the aKey/aValue pair in the hash dictionary.   
 aKey must be convertible to a Symbol.

 Rebuilds the hash table if the addition caused the number of collisions 
 to exceed the limit allowed."

^ super at: (aKey asSymbol) put: aValue
%

category: 'Accessing'
method: SymbolKeyValueDictionary
keys

"Returns a SymbolSet containing the receiver's keys."

| result |
result := SymbolSet new .
self keysAndValuesDo:[ :aKey :aValue | result add: aKey ].
^ result
%

! fixed 42716, 44204, 45367
method:
at: aKey ifAbsent: aBlock
  | sym |
  aKey ifNotNil:[ sym := Symbol _existingWithAll: aKey ].
  sym ifNil:[
    aBlock ifNil:[^ self _errorKeyNotFound: aKey ] .
    ^ aBlock value
  ] ifNotNil:[
    ^ super at: sym ifAbsent: aBlock
  ]
% 
method:
at: aKey otherwise: aValue

  (Symbol _existingWithAll: aKey) 
     ifNil:[ ^ aValue ]
     ifNotNil:[ :sym | ^ super at: sym otherwise: aValue ]
%

category: 'Removing'
method:
removeKey: aKey ifAbsent: aBlock

  (Symbol _existingWithAll: aKey) ifNil:[
    aBlock ifNil:[^ self _errorKeyNotFound: aKey ] .
    ^ aBlock value
  ] ifNotNil:[ :sym |
    ^ super removeKey: sym ifAbsent: aBlock
  ]
%
method:
removeKey: aKey otherwise: aValue

  (Symbol _existingWithAll: aKey) 
     ifNil:[ ^ aValue ]
     ifNotNil:[ :sym | ^ super removeKey: sym otherwise: aValue ]
%

