!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   SymbolSet, IdentitySet, IdentityBag, UnorderedCollection, Collection,
!   Object.
!
!=========================================================================

removeallmethods SymbolSet
removeallclassmethods SymbolSet

category: 'For Documentation Installation only'
classmethod: SymbolSet
installDocumentation

self comment:
'A SymbolSet is an IdentitySet whose elements must be canonical symbols
 (Symbols or DoubleByteSymbols).

Constraints:
	_varyingSize: Object
	_numEntries: Object
	_indexedPaths: Object
	_levels: Object
	[elements]: Symbol' .
%

! remove: inherited from IdentitySet
! remove: aSymbol ifAbsent: aBlock  inherited from IdentitySet

category: 'Accessing'
method: SymbolSet
_returnValueOf: anObject

"Returns the element of the receiver whose value is the same as the argument.
 If the argument is not equal to any value in the receiver, then add the
 argument to the receiver."

|symbolizedObject|

symbolizedObject := anObject asSymbol.
self add: symbolizedObject.
^ symbolizedObject
%

! add: inherited from IdentitySet
! addAll:  inherited from IdentitySet

category: 'Deprecated'
method: SymbolSet
_addSymbol: aSymbol

self deprecated: '_addSymbol: Obsolete, provided for compatibility.
 Same functionality as IdentitySet | add: '.

^ self add: aSymbol
%

! delete rehashForConversion, #46923  

