!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
!=========================================================================

! class TransientShortArray is created in bom

set class TransientShortArray
removeallmethods 
removeallclassmethods 

category: 'For Documentation Installation only'
classmethod:
installDocumentation

self comment:
'Instances of TransientShortArray may not be committed.
 Instances may have a contigous in-memory physical size
 of up to 65K bytes.  Elements are 16bit signed integers.
 Uninitialized elements are zero.'.
%

category: 'Instance creation'
classmethod:
_basicNew: numElements

"Create a new instance of the specified size. The maximum
 allowed size is 32752 elements . "

<primitive: 814>
self _primitiveFailed: #_basicNew: args: { numElements }
%

category: 'Copying'
method:
replaceFrom: startIndex to: stopIndex with: aSeqCollection startingAt: repIndex

"Disallowed."
^ self shouldNotImplement: #replaceFrom:to:with:startingAt:
%

method:
replaceFrom: startIndex to: stopIndex with: aSeqCollection

"Disallowed."
^ self shouldNotImplement: #replaceFrom:to:with:
%

method:
replaceFrom: startIndex to: stopIndex withObject: anObject

"Disallowed."
^ self shouldNotImplement: #replaceFrom:to:withObject:
%

