!=========================================================================
! Copyright (C) GemTalk Systems 2013-2020.  All Rights Reserved.
!
! $Id: rcrangeindex.gs 31598 2013-10-08 18:58:59Z dhenrich $
!
! Superclass Hierarchy:
!   UnicodeRangeEqualityIndex, RangeEqualityIndex, IdentityIndex, Array, 
!   SequenceableCollection, Collection, Object.
!
! class created in idxclasses.topaz
!=========================================================================

expectvalue %Boolean
doit
UnicodeRangeEqualityIndex comment:
'UnicodeRangeEqualityIndex is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for direct use by customers.'.
true
%

removeallmethods UnicodeRangeEqualityIndex
removeallclassmethods UnicodeRangeEqualityIndex

category: 'conversion'
set compile_env: 0
method: UnicodeRangeEqualityIndex
asIndexSpecification
  ^ (UnicodeIndexSpecification
    path: self pathComponentsString
    collator: self collator)
    requirePathTerms: self termsRequired;
    legacyIndex: true;
    yourself
%
category: 'accessing'
set compile_env: 0
method: UnicodeRangeEqualityIndex
collator
  "Returns IcuCollator to be used when comparing Unicode strings"

  ^ collator
%
category: 'accessing'
set compile_env: 0
method: UnicodeRangeEqualityIndex
collator: anIcuCollator
  "Set the receiver's collator. Use a copy of anIcuCollator to disallow 
   changes to strength, etc, that might affect the sort ordering. "

  collator := anIcuCollator copy immediateInvariant
%
category: 'accessing'
set compile_env: 0
method: UnicodeRangeEqualityIndex
lastElementClass
  ^ CharacterCollection
%
category: 'instance creation'
set compile_env: 0
classmethod: UnicodeRangeEqualityIndex
newWithCollator: anIcuCollator
  "Create a new instance and initialize its B-tree root."

  | newOne btreeRoot |
  newOne := super new.
  newOne collator: anIcuCollator.
  btreeRoot := IndexManager current btreeBasicLeafNodeClass new.
  btreeRoot collator: newOne collator.  "explicitly share invariant collator with index"
  newOne btreeRoot: btreeRoot.
  ^ newOne
%
category: 'instance creation'
set compile_env: 0
classmethod: UnicodeRangeEqualityIndex
newWithLastElementClass: aClass
  self shouldNotImplement: #'newWithLastElementClass:'
%
category: 'Updating'
set compile_env: 0
method: UnicodeRangeEqualityIndex
_setPathTermState
  "For each path term but the last, indicate the need to update the index
 dictionary.  For the last path term, indicate the need to update the B-tree.
 Indicate if the last object along the path needs a dependency list."

  | lastPathTerm |
  1 to: self size - 1 do: [ :i | (self at: i) updateDict: indexDictionary ].
  lastPathTerm := self at: self size.
  lastPathTerm updateBtree: self.
  lastPathTerm needsDepList: true
%
category: 'Testing'
set compile_env: 0
method: UnicodeRangeEqualityIndex
_canCompareWith: aKey
  "Returns whether the receiver can make B-tree comparisons with the given key."

  aKey == nil
    ifTrue: [ ^ true ].
  ^ btreeRoot _canCompare: aKey withClass: Unicode7
%
category: 'Accessing'
set compile_env: 0
method: UnicodeRangeEqualityIndex
lastElementClassDescription
  "answer a description of the lastElementClass of the receiver, 
   suitable for use in an error message"

  ^ 'CharacterCollection including Unicode String classes'
%
category: 'Accessing'
set compile_env: 0
method: UnicodeRangeEqualityIndex
sortNodeClass
  "Returns the class of SortNode to use ... use basic sort node class"

  ^ self indexManager sortNodeClass
%
category: 'Testing'
set compile_env: 0
method: UnicodeRangeEqualityIndex
_checkSameLastElementClassAs: indexObj
  ^ indexObj _checkSameLastElementClassAsUnicodeIndex: self
%
category: 'Testing'
set compile_env: 0
method: UnicodeRangeEqualityIndex
_checkSameLastElementClassAsEqualityIndex: equalityIndexObj
  ^ false
%
category: 'Testing'
set compile_env: 0
method: UnicodeRangeEqualityIndex
_checkSameLastElementClassAsUnicodeIndex: aUnicodeIndexObj
  ^ true
%
category: 'Stream Accessing'
method: UnicodeRangeEqualityIndex
btreeComparisonQuerySpec
  ^ BtreeUnicodeComparisonQuerySpec new
    collator: self collator;
    yourself
%
